#!/bin/bash
########################################################### 
# AUTHOR  : Rinat K. Nugaev - http://www.nugaev.net - support@nugaev.net
# DATE    : 19-07-2017
# EDITED  : 19-07-2017 
# COMMENT : This script creates tunnels for Unicredit servers in DMZ
#           Use it for your own risk! 
# VERSION : 1.3
########################################################### 
#
#CHANGELOG 
# Version 1.0: 19-07-2017 - Changed the code 
# - Added better variables checking
# - Changed users's array creating 
# - Function added 
user=nrk
#Defining some colours for fun )))
RED='\033[0;31m'
NC='\033[0m'
GREEN='\033[0;33m'
#Starting ssh-agent
eval `ssh-agent -s`
#Adding keys to ssh-agent
ssh-add

#Ask user for username
if [ -z "$user"] ; then
    echo "Username not defined in script, asking for username!"
    read -p "Enter your username like PertrovPP:" user
else
   echo "Username defined! Trying to connect..."
fi 

#Cheking username for ssh connection and if good then add it to script variables
statusssh=$(ssh -o BatchMode=yes -o ConnectTimeout=5 -p 10022 $user@tunnel01.rbtechnologies.ru echo ok 2>&1)
if [[ $statusssh == ok ]] ; then
  echo "Adding username $user for future use in script"
  sed -i -e 's/user=nrk/user='$user'/g' $0
else
  echo other_error
fi



#Create function with port and name of hostname
function create_tunnel
{
ssh -f -N -o ExitOnForwardFailure=yes -p 10022 -L $1:$2.rbtechnologies.ru:3389 $user@tunnel01.rbtechnologies.ru
}

#Declaring array of tunnels
declare -A tunnels

tunnels+=( ["iv176"]="5555" ["ks262"]="5556" ["vs1027"]="5557" )

#Connecting...
for conn in "${!tunnels[@]}"; do
if create_tunnel ${tunnels[$conn]} $conn ; then
    echo -e  "${GREEN}Tunnel to the DMZ host $conn succesufully created!${NC}"
else
    echo -e "${RED}Tunnel creation to the $conn FAIL ${NC}"
fi
done

exit 0



