#!/bin/bash
########################################################### 
# AUTHOR  : Rinat K. Nugaev - http://www.nugaev.net - support@nugaev.net
# DATE    : 19-07-2017
# EDITED  : 19-07-2017 
# COMMENT : This script creates tunnels for Unicredit servers in DMZ
#           Use it for your own risk! 
# VERSION : 1.0
########################################################### 
#
#CHANGELOG 
# Version 1.0: 19-07-2017 - Changed the code 
# - Added better variables checking
# - Changed users's array creating 



user=""
#Defining some colours for fun )))
RED='\033[0;31m'
NC='\033[0m'
GREEN='\033[0;33m'
#Starting ssh-agent
eval `ssh-agent -s`
#Adding keys to ssh-agent
ssh-add

#Ask user for username
if [ -z "$user"] ; then
    echo "Username not defined in script, asking for username!"
    read -p "Enter your username like PertrovPP:" user
else
   echo "Username defined! Trying to connect..."
fi 
#Declaring array of tunnels
declare -A tunnels

tunnels+=( ["iv176"]="ssh -f -N -o ExitOnForwardFailure=yes -p 10022 -L 5555:iv176.rbtechnologies.ru:3389 $user@tunnel01.rbtechnologies.ru" ["ks262"]="ssh -f -N -o ExitOnForwardFailure=yes -p 10022 -L 5556:ks261.rbtechnologies.ru:3389 $user@tunnel01.rbtechnologies.ru" ["vs1027"]="ssh -f -N -o ExitOnForwardFailure=yes -p 10022 -L 5557:vs1027.rbtechnologies.ru:3389 $user@tunnel01.rbtechnologies.ru" )

#Connecting...
for conn in "${!tunnels[@]}"; do
if ${tunnels[$conn]} ; then
    echo -e  "${GREEN}Tunnel to the DMZ host $conn succesufully created!${NC}"
else
    echo -e "${RED}Tunnel creation to the $conn FAIL (((${NC}"
fi
done

exit 0

