Import-Module BitsTransfer
#Getting and defining some vars
$PathZabbix = ${env:ProgramFiles} + '\Zabbix'
$osarch = wmic os get OSArchitecture /value
$ZabbixConf = $PathZabbix + '\conf\zabbix_agentd.conf'

#Getting monitoring server ip for Firewall Rule
$monserverip = (Test-Connection -ComputerName monitoring.nugaev.net -count 1).IPV4Address.ipaddressTOstring


#Downloading and unzip zabbix agent 
$url = "https://support.nugaev.net/files/distrib/zabbix_agent.zip"
$output = $env:TEMP
Start-BitsTransfer -Source $url -Destination $output
#unzip it 
Add-Type -AssemblyName System.IO.Compression.FileSystem
function Unzip
{
    param([string]$zipfile, [string]$outpath)

    [System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
}

Unzip  $output\zabbix_agent.zip $PathZabbix


if ($osarch -eq "OSArchitecture=64-bit")
    {
    $osarch = "win64"
    }
else
    {
    $osarch = "win32"
    }

$HostnameFull ="$env:computername.$env:userdnsdomain"

#Creating config


$confcont = "#This is a Nugaev NET Monitoring Server config file
LogFile=${env:ProgramFiles}\Zabbix\log\zabbix_agentd.log
Server=monitoring.nugaev.net

ServerActive=monitoring.nugaev.net

Hostname=$HostnameFull
"

Add-Content -Value "$confcont" -Path $ZabbixConf
    
& "c:\Program Files\Zabbix\bin\win64\zabbix_agentd.exe" --config "c:\Program Files\Zabbix\conf\zabbix_agentd.conf" --install
start-service "Zabbix Agent"
cd ${ENV:temp}
New-NetFirewallRule -DisplayName "Zabbix" -RemoteAddress $monserverip  -Profile Any -Action Allow -Direction Inbound -Protocol TCP -LocalPort 10050
New-NetFirewallRule -DisplayName "ZabbixOUT" -RemoteAddress $monserverip  -Profile Any -Action Allow -Direction OutBound -Protocol TCP -LocalPort 10050
New-NetFirewallRule -DisplayName "ZabbixOUT" -RemoteAddress $monserverip  -Profile Any -Action Allow -Direction OutBound -Protocol TCP -LocalPort 10051
Write-host "Firewall rule for Monitoring Server added..."
Write-host "Installation completed!"
