# AUTHOR  : Rinat K. Nugaev - http://www.nugaev.net - code@nugaev.net
# DATE    : 06.06.2018 
# EDIT    : 11.06.2018
# COMMENT :  
# 
#           
# VERSION : 0.2 
# 
# CHANGELOG 
# Version 0.3: Added some improvements
<#
.NAME
 Zabbix Agent Install.

.SYNOPSIS
 Installs Zabbix Agent Service and starts it.

.Descripton
 This script downloading zabbix agent zip archive unzip this archive to the ProgramFiles folder
 Script installs Zabbix Agent Service
 This script install only 64 bit version
 
.Remarks
 This can then be run manually on each server

.Author: Rinat K. Nugaev
.Date: 06/08/2018

#>


#Checking that script run with admin privilegies
If (-NOT ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(`

    [Security.Principal.WindowsBuiltInRole] "Administrator"))

{

    Write-Warning "You do not have Admin rights to run this script!`nPlease`
     re-run this script with Admin rights!"

    Break

}
#Importing module BitsTransfer for downloading zip archive with zabbix agent
Import-Module BitsTransfer -ErrorAction stop
###VARIABLES
# $UrlDistZabbix where your zabbix_agent archive 
$UrlDistZabbix = "https://www.zabbix.com/downloads/3.4.6/zabbix_agents_3.4.6.win.zip"
#$UrlDistZabbix = "https://support.nugaev.net/files/distrib/zabbix_agent.zip"

# $MonitoringServer DNS Name of your Monitoring server
$MonitoringServer =  "monitoring.nugaev.net"

# $temparchivedir where you'll download zabbix_agent archive
$TempArchive = "$env:TEMP\zabbix_agent.zip"
# $PathZabbix folder where you'll install zabbix agent
$PathZabbix = ${env:ProgramFiles} + '\Zabbix'
# $ZabbixConf zabbix agent config
$ZabbixConf = $PathZabbix + '\conf\zabbix_agentd.win.conf'
#Getting monitoring server ip for Firewall Rule

#$MonServerIp = [System.Net.Dns]::GetHostAddresses("$MonitoringServer").ipaddressTOstring
$MonServerIp = (Resolve-DNSName monitoring.nugaev.net).IP4Address
#Getting computer hostname for config file
$CompHostName ="$env:computername.$env:userdnsdomain"
#Removing dot from end of the hostname (dot appears when computer is not a domain member)
$CompHostName = $CompHostName -replace "\.(?<=\z)", ""
###Creating config file
#Preparing content for config file
$ConfContent = "
LogFile=$PathZabbix\log\zabbix_agentd.log
Server=$MonitoringServer 
ServerActive=$MonitoringServer 
Hostname=$CompHostName
HostMetadataItem=system.uname
"
#Defining $OsArch variable. It depend on system platform, 64 or 32 bits
$OsArch = wmic os get OSArchitecture /value
if ($OsArch -eq "OSArchitecture=64-bit")
  {
    $OsArch = 'win64'
  }
else
  {
    $OsArch = 'win32'
  }

#Downloading and unzip Zabbix Agent 
Try 
  {
    Start-BitsTransfer -Source $UrlDistZabbix -Destination $TempArchive -ErrorAction stop
  }
Catch
  {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    write-host "Cannot download Zabbix Agent archive from link $UrlDistZabbix"
    write-host $ErrorMessage
    Break
  }

#Unzip Zabbix Agent archive
Add-Type -AssemblyName System.IO.Compression.FileSystem
function UnZip
  {
    param([string]$zipfile, [string]$outpath)

    [System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
  }
UnZip  $TempArchive $PathZabbix
Remove-Item -Force $TempArchive
#Creating Zabbix Agent log folder
New-Item -ItemType directory -Path $PathZabbix\log -ErrorAction Stop | out-null
#Setting up the content to the config file
Set-Content -Value "$ConfContent" -Path $ZabbixConf
#Defining zabbix install command. It depends on $OsArch variable
$ZabbixInstallCommand = "`"$PathZabbix\bin\$OsArch\zabbix_agentd.exe`" --config `"$ZabbixConf`""

#Installing Zabbix Service
Try 
  {
    New-Service -Name "Zabbix Agent" -BinaryPathName $ZabbixInstallCommand `
    -DisplayName "Zabbix Agent" -Description "Provides Monitoring" -StartupType "Automatic" | out-null
  }
Catch
  {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    write-host "Cannot Install Zabbix Service!!!"
    write-host $ErrorMessage
    Break
  }

#Adding firewall rules for Zabbix Agent and Zabbix Server
Try
  {
    New-NetFirewallRule -DisplayName "Zabbix Agent IN" -RemoteAddress $MonServerIp `
    -Profile Any -Action Allow -Direction Inbound -Protocol TCP -LocalPort 10050 | out-null
    New-NetFirewallRule -DisplayName "Zabbix Agent OUT" -RemoteAddress $MonServerIp `
    -Profile Any -Action Allow -Direction OutBound -Protocol TCP -LocalPort 10051 | out-null
  }
Catch
  {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    write-host "Cannot Add Firewall Rules..."
    write-host $ErrorMessage
    Break
  }


#Starting Zabbix Agent
Try
  {
    Start-Service -name  "Zabbix Agent" -ErrorAction Stop
    
  }
Catch
  {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    write-host "Cannot Start Zabbix Service. See $PathZabbix\log\zabbix_agentd.log`
  for details"
    write-host $ErrorMessage
    Break
  }

For ($i=5; $i -gt 1; $i-) {  
    Write-Progress -Activity "`nInstallation completed! Waiting Zabbix Agent starts..." `
     -SecondsRemaining $i
    Start-Sleep 1
}

Get-content $PathZabbix\log\zabbix_agentd.log
