# AUTHOR  : Rinat K. Nugaev - http://www.nugaev.net - code@nugaev.net
# DATE    : 06.06.2018 
# EDIT    : 08.06.2018
# COMMENT :  
# 
#           
# VERSION : 0.2 
# 
# CHANGELOG 
# Version 0.3:

#Importing module BitsTransfer
Try
{
Import-Module BitsTransfer -ErrorAction stop
}
Catch
{
$ErrorMessage = $_.Exception.Message
write-host "I cannot import the Bits module ((("
write-host $ErrorMessage
Break
}
#Getting and defining some vars
$PathZabbix = ${env:ProgramFiles} + '\Zabbix'

#$osarch = wmic os get OSArchitecture /value
$ZabbixConf = $PathZabbix + '\conf\zabbix_agentd.conf'
#Getting monitoring server ip for Firewall Rule
$monserverip = (Test-Connection -ComputerName monitoring.nugaev.net -count 1).IPV4Address.ipaddressTOstring
#Downloading and unzip zabbix agent 
Try 
{
$url = "https://support.nugaev.net/files/distrib/zabbix_agent.zip"
$output = $env:TEMP
Start-BitsTransfer -Source $url -Destination $output -ErrorAction stop
}
Catch
{
$ErrorMessage = $_.Exception.Message
$FailedItem = $_.Exception.ItemName
write-host "I cannot download the archive ((("
write-host $ErrorMessage
Break
}

#unzip it 
Add-Type -AssemblyName System.IO.Compression.FileSystem
function Unzip
{
    param([string]$zipfile, [string]$outpath)

    [System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
}
Unzip  $output\zabbix_agent.zip $PathZabbix

#Defining platform for version of zabbix agent
<#
if ($osarch -eq "OSArchitecture=64-bit")
    {
    $osarch = "win64"
    }
else
    {
    $osarch = "win32"
    }
#>

#Getting computer hostname for config file
$HostnameFull ="$env:computername.$env:userdnsdomain"
#Removing dot from end of the hostname (this behavior possible if computer is not domain joined)
$HostnameFull = $HostnameFull -replace "\.(?<=\z)", ""
#Creating config
#Preparing content for config gile
$confcont = "#This is a Nugaev NET Monitoring Server config file
LogFile=${env:ProgramFiles}\Zabbix\log\zabbix_agentd.log
Server=monitoring.nugaev.net
ServerActive=monitoring.nugaev.net
Hostname=$HostnameFull
HostMetadataItem=system.uname
"
#Adding content to the config file
Add-Content -Value "$confcont" -Path $ZabbixConf

#Installing zabbix agent as a service    
& "c:\Program Files\Zabbix\bin\win64\zabbix_agentd.exe" --config "c:\Program Files\Zabbix\conf\zabbix_agentd.conf" --install
#Starting zabbix agent
Get-service -name  "Zabbix Agent" | start-service

#Dont remember why but entering to the temporary directory
cd ${ENV:temp}
#Adding firewall rules for zabbix agent inbound for zabbix server and outbound for agent
New-NetFirewallRule -DisplayName "Zabbix" -RemoteAddress $monserverip  -Profile Any -Action Allow -Direction Inbound -Protocol TCP -LocalPort 10050
New-NetFirewallRule -DisplayName "ZabbixOUT" -RemoteAddress $monserverip  -Profile Any -Action Allow -Direction OutBound -Protocol TCP -LocalPort 10050
New-NetFirewallRule -DisplayName "ZabbixOUT" -RemoteAddress $monserverip  -Profile Any -Action Allow -Direction OutBound -Protocol TCP -LocalPort 10051
Write-host "Firewall rule for Monitoring Server added..."
Write-host "Installation completed!"

Write-host "Dont worry.. some red output because cmd command run in powershell )))"