# AUTHOR  : Rinat K. Nugaev - http://www.nugaev.net - code@nugaev.net
# DATE    : 06.06.2018 
# EDIT    : 08.06.2018
# COMMENT :  
# 
#           
# VERSION : 0.2 
# 
# CHANGELOG 
# Version 0.3:
<#
.NAME
 Zabbix Agent Install.

.SYNOPSIS
 Installs Zabbix Agent Service and starts it.

.Descripton
 This script downloading zabbix agent zip archive unzip this archive to the ProgramFiles folder
 Script installs Zabbix Agent Service
 This script install only 64 bit version
 
.Remarks
 This can then be run manually on each server

.Author: Rinat K. Nugaev
.Date: 06/08/2018

#>


#Checking that script run with admin privilegies
If (-NOT ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(`

    [Security.Principal.WindowsBuiltInRole] "Administrator"))

{

    Write-Warning "You do not have Admin rights to run this script!`nPlease`
     re-run this script with Admin rights!"

    Break

}
#Importing module BitsTransfer for downloading zip archive with zabbix agent
Try
{
Import-Module BitsTransfer -ErrorAction stop
}
Catch
{
$ErrorMessage = $_.Exception.Message
write-host "Cannot import Bits module..."
write-host $ErrorMessage
Break
}
#Getting and defining some vars
#$urldistzabbix where your zabbix_agent archive 
$urldistzabbix = "https://support.nugaev.net/files/distrib/zabbix_agent.zip"
#$temparchivedir where you'll download zabbix_agent archive
$temparchivedir = $env:TEMP
#$PathZabbix folder where you'll install zabbix agent
$PathZabbix = ${env:ProgramFiles} + '\Zabbix'
#$ZabbixConf zabbix agent config
$ZabbixConf = $PathZabbix + '\conf\zabbix_agentd.conf'
#Your OS architechture
$OsArch = wmic os get OSArchitecture /value
#Getting monitoring server ip for Firewall Rule
$monserverip = (Test-Connection -ComputerName monitoring.nugaev.net -count 1).IPV4Address.ipaddressTOstring
#Downloading and unzip zabbix agent 
Try 
  {
    Start-BitsTransfer -Source $urldistzabbix -Destination $temparchivedir -ErrorAction stop
  }
Catch
  {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    write-host "I cannot download the archive ((("
    write-host $ErrorMessage
    Break
}

#unzip it 
Add-Type -AssemblyName System.IO.Compression.FileSystem
function Unzip
  {
    param([string]$zipfile, [string]$outpath)

    [System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
  }
Unzip  $temparchive\zabbix_agent.zip $PathZabbix
Remove-Item -Force $temparchive\zabbix_agent.zip
#Getting computer hostname for config file
$HostnameFull ="$env:computername.$env:userdnsdomain"
#Removing dot from end of the hostname (this behavior possible if computer is not domain joined)
$HostnameFull = $HostnameFull -replace "\.(?<=\z)", ""
#Creating config
#Preparing content for config gile
$confcont = "#This is a Nugaev NET Monitoring Server config file
LogFile=${env:ProgramFiles}\Zabbix\log\zabbix_agentd.log
Server=monitoring.nugaev.net
ServerActive=monitoring.nugaev.net
Hostname=$HostnameFull
HostMetadataItem=system.uname
"
#Adding content to the config file
Add-Content -Value "$confcont" -Path $ZabbixConf

#Defining $OsArch variable. It depend on system platform, 64 or 32 bits
$OsArch = wmic os get OSArchitecture /value
if ($OsArch -eq "OSArchitecture=64-bit")
    {
    $OsArch = 'win64'
    }
else
    {
    $OsArch = 'win32'
    }


#Defining zabbix install command. It depends on $OsArch variable
$ZabbixInstallCommand = "`"C:\Program Files\Zabbix\bin\$OsArch\zabbix_agentd.exe`" --config `"C:\Program Files\Zabbix\conf\zabbix_agentd.conf`""

#Installing Zabbix Service
Try 
{
New-Service -Name "Zabbix Agent" -BinaryPathName $ZabbixInstallCommand -DisplayName "Zabbix Agent" -Description "Provides Monitoring" -StartupType "Automatic"
}
Catch
{
$ErrorMessage = $_.Exception.Message
$FailedItem = $_.Exception.ItemName
write-host "Cannot Install Zabbix Service ((("
write-host $ErrorMessage
Break
}

#Starting zabbix agent
Try
  {
    start-service -name  "Zabbix Agent" -ErrorAction Stop
  }
Catch
  {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    write-host "Cannot Start Zabbix Service ((("
    write-host $ErrorMessage
    Break
  }
#Dont remember why but entering to the temporary directory
cd ${ENV:temp}
#Adding firewall rules for zabbix agent inbound for zabbix server and outbound for agent
Try
{
New-NetFirewallRule -DisplayName "Zabbix Agent IN" -RemoteAddress $monserverip `
 -Profile Any -Action Allow -Direction Inbound -Protocol TCP -LocalPort 10050 | out-null
New-NetFirewallRule -DisplayName "Zabbix Agent OUT" -RemoteAddress $monserverip `
 -Profile Any -Action Allow -Direction OutBound -Protocol TCP -LocalPort 10051 | out-null
}
Catch
{
$ErrorMessage = $_.Exception.Message
$FailedItem = $_.Exception.ItemName
write-host "Cannot Add Firewall Rules..."
write-host $ErrorMessage
Break
}

Write-host "Firewall rules for Zabbix Agent added..."
Write-host "Installation completed!"